/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.HwmcaParentObjectProperties;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class HwmcaParentObject
extends HwmcaObject
implements HwmcaParentObjectProperties,
PropertyChangeListener {
    public static final int OBJECT_ONLY = 0;
    public static final int CHILDREN_ONLY = 1;
    public static final int OBJECT_AND_CHILDREN = 2;
    private ArrayList children = null;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "ParentObject");
    private Object childMonitor = new Object();
    private static final String TRACE_MASKT = "XFRMPOBT";
    private static final String TRACE_MASKF = "XFRMPOBF";
    private static final String TRACE_MASKD = "XFRMPOBD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaParentObject;

    protected HwmcaParentObject() {
        this.children = new ArrayList();
        this.propertyChangeSupport = new PropagatedPropertyChangeSupport();
    }

    protected HwmcaParentObject(PersistentData data, String persistKey) {
        super(((Persistent)data).parentData, persistKey);
        this.children = ((Persistent)data).children;
        this.propertyChangeSupport = new PropagatedPropertyChangeSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ObjectId child) {
        Trace.trace(TRACE_MASKF, "-> addChild(child=" + child + ")");
        if (this.propertyChangeSupport.hasListeners()) {
            ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).propagateListeners(child);
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.childMonitor;
            synchronized (object2) {
                this.children.add(child);
            }
            this.fireContainerPropertyAdd("Children", new ObjectId[]{child});
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- addChild()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(Collection children) {
        Object childId;
        Trace.trace(TRACE_MASKT, "-> addChildren(children=" + children + ")");
        if (this.propertyChangeSupport.hasListeners()) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                childId = (ObjectId)iterator.next();
                ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).propagateListeners((ObjectId)childId);
            }
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            childId = this.childMonitor;
            synchronized (childId) {
                this.children.addAll(children);
            }
            ObjectId[] childArray = new ObjectId[children.size()];
            children.toArray(childArray);
            this.fireContainerPropertyAdd("Children", childArray);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- addChildren()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(ObjectId child) {
        boolean removed;
        Trace.trace(TRACE_MASKT, "-> removeChild(child=" + child + ")");
        if (this.propertyChangeSupport.hasListeners()) {
            ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).removeListeners(child);
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.childMonitor;
            synchronized (object2) {
                removed = this.children.remove(child);
            }
            if (removed) {
                this.fireContainerPropertyRemove("Children", new ObjectId[]{child});
            }
        }
        if (removed) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKT, "<- removeChild(returns " + removed + ")");
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChildren(Collection children) {
        boolean removed;
        Trace.trace(TRACE_MASKT, "-> removeChildren(children=" + children + ")");
        if (this.propertyChangeSupport.hasListeners()) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                ObjectId childId = (ObjectId)iterator.next();
                ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).removeListeners(childId);
            }
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            ObjectId[] childArray = null;
            Object object2 = this.childMonitor;
            synchronized (object2) {
                ArrayList oldList = (ArrayList)this.children.clone();
                removed = this.children.removeAll(children);
                if (removed) {
                    oldList.removeAll(this.children);
                    childArray = new ObjectId[oldList.size()];
                    oldList.toArray(childArray);
                }
            }
            if (removed) {
                this.fireContainerPropertyRemove("Children", childArray);
            }
        }
        if (removed) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKT, "<- removeChildren(returns " + removed + ")");
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChildren() {
        Trace.trace(TRACE_MASKT, "-> removeAllChildren()");
        if (this.propertyChangeSupport.hasListeners()) {
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                ObjectId childId = (ObjectId)iterator.next();
                ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).removeListeners(childId);
            }
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            ObjectId[] childArray;
            Object object2 = this.childMonitor;
            synchronized (object2) {
                childArray = new ObjectId[this.children.size()];
                this.children.toArray(childArray);
                this.children.clear();
            }
            this.fireContainerPropertyRemove("Children", childArray);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- removeAllChildren()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(Collection children) {
        Trace.trace(TRACE_MASKF, "-> setChildren(children=" + children + ")");
        ObjectId[] oldChildren = null;
        ObjectId[] newChildren = null;
        if (this.propertyChangeSupport.hasListeners()) {
            ObjectId childId;
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                childId = (ObjectId)iterator.next();
                ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).removeListeners(childId);
            }
            iterator = children.iterator();
            while (iterator.hasNext()) {
                childId = (ObjectId)iterator.next();
                ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).propagateListeners(childId);
            }
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.childMonitor;
            synchronized (object2) {
                ArrayList uniqueNewChildren = new ArrayList();
                ArrayList uniqueOldChildren = new ArrayList(this.children);
                if (children != null) {
                    uniqueNewChildren.addAll(children);
                    uniqueNewChildren.removeAll(this.children);
                    newChildren = new ObjectId[uniqueNewChildren.size()];
                    uniqueNewChildren.toArray(newChildren);
                    uniqueOldChildren.removeAll(children);
                }
                oldChildren = new ObjectId[uniqueOldChildren.size()];
                uniqueOldChildren.toArray(oldChildren);
                this.children.clear();
                if (children != null) {
                    this.children.addAll(children);
                }
            }
            this.firePropertyChange("Children", oldChildren, newChildren);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setChildren()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        Object object = this.childMonitor;
        synchronized (object) {
            return (List)this.children.clone();
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener, int registerObjects) {
        Trace.trace(TRACE_MASKT, "<> addPropertyChangeListener(propertyName=" + propertyName + ",listener=" + listener + ",registerObjects=" + (registerObjects == 2 ? "OBJECT_AND_CHILDREN" : (registerObjects == 1 ? "CHILDREN_ONLY" : "OBJECT_ONLY")) + ")");
        if (!(((PropagatedPropertyChangeSupport)this.propertyChangeSupport).hasPropagatedListeners() || registerObjects != 1 && registerObjects != 2)) {
            mom.addPropertyChangeListener(this);
        }
        PropagatedListenerInfo info = new PropagatedListenerInfo(propertyName, listener, registerObjects);
        ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).addPropertyChangeListener(info, this.getChildren());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener, int registerObjects) {
        Trace.trace(TRACE_MASKT, "<> addPropertyChangeListener(listener=" + listener + ",registerObjects=" + (registerObjects == 2 ? "OBJECT_AND_CHILDREN" : (registerObjects == 1 ? "CHILDREN_ONLY" : "OBJECT_ONLY")) + ")");
        if (!(((PropagatedPropertyChangeSupport)this.propertyChangeSupport).hasPropagatedListeners() || registerObjects != 1 && registerObjects != 2)) {
            mom.addPropertyChangeListener(this);
        }
        PropagatedListenerInfo info = new PropagatedListenerInfo(listener, registerObjects);
        ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).addPropertyChangeListener(info, this.getChildren());
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener, int registerObjects) {
        Trace.trace(TRACE_MASKT, "<> removePropertyChangeListener(propertyName=" + propertyName + ",listener=" + listener + ",registerObjects=" + (registerObjects == 2 ? "OBJECT_AND_CHILDREN" : (registerObjects == 1 ? "CHILDREN_ONLY" : "OBJECT_ONLY")) + ")");
        PropagatedListenerInfo info = new PropagatedListenerInfo(propertyName, listener, registerObjects);
        ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).removePropertyChangeListener(info, this.getChildren());
        if (!(((PropagatedPropertyChangeSupport)this.propertyChangeSupport).hasPropagatedListeners() || registerObjects != 1 && registerObjects != 2)) {
            mom.removePropertyChangeListener(this);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener, int registerObjects) {
        Trace.trace(TRACE_MASKT, "<> removePropertyChangeListener(listener=" + listener + ",registerObjects=" + (registerObjects == 2 ? "OBJECT_AND_CHILDREN" : (registerObjects == 1 ? "CHILDREN_ONLY" : "OBJECT_ONLY")) + ")");
        HwmcaObject.ListenerInfo info = new HwmcaObject.ListenerInfo(listener);
        ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).removePropertyChangeListener(info, this.getChildren());
        if (!(((PropagatedPropertyChangeSupport)this.propertyChangeSupport).hasPropagatedListeners() || registerObjects != 1 && registerObjects != 2)) {
            mom.removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource().equals(mom)) {
            Trace.trace(TRACE_MASKF, "-> propertyChange(propertyName=" + event.getPropertyName() + ",this=" + this + ")");
            try {
                HwmcaObject[] newMomObjects = (HwmcaObject[])event.getNewValue();
                HwmcaObject[] oldMomObjects = (HwmcaObject[])event.getOldValue();
                ArrayList<ObjectId> addedChildren = new ArrayList<ObjectId>();
                ArrayList<ObjectId> removedChildren = new ArrayList<ObjectId>();
                Iterator iterator = this.getChildren().iterator();
                while (iterator.hasNext()) {
                    int ix;
                    ObjectId childId = (ObjectId)iterator.next();
                    if (newMomObjects != null) {
                        for (ix = 0; ix < newMomObjects.length; ++ix) {
                            if (!newMomObjects[ix].getObjectId().equals(childId)) continue;
                            ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).propagateListeners(childId);
                            addedChildren.add(newMomObjects[ix].getObjectId());
                        }
                    }
                    if (oldMomObjects == null) continue;
                    for (ix = 0; ix < oldMomObjects.length; ++ix) {
                        if (!oldMomObjects[ix].getObjectId().equals(childId)) continue;
                        ((PropagatedPropertyChangeSupport)this.propertyChangeSupport).removeListeners(childId);
                        removedChildren.add(oldMomObjects[ix].getObjectId());
                    }
                }
            }
            catch (Exception exc) {
                new FrameworkLog(logInfo, 2456, exc).log();
            }
            Trace.trace(TRACE_MASKF, "<- propertyChange(this=" + this + ")");
        }
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.children = (ArrayList)this.getChildren();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PropagatedPropertyChangeSupport
    extends HwmcaObject.PropertyChangeSupport {
        private static final boolean DEBUG = false;

        public void addPropertyChangeListener(PropagatedListenerInfo info, Collection children) {
            super.addPropertyChangeListener(info);
            if (info.isPropagated()) {
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    ObjectId childId = (ObjectId)iterator.next();
                    if (childId.isInstanceOf(class$com$ibm$hwmca$fw$managed$HwmcaParentObject == null ? HwmcaParentObject.class$("com.ibm.hwmca.fw.managed.HwmcaParentObject") : class$com$ibm$hwmca$fw$managed$HwmcaParentObject)) {
                        HwmcaObject.mom.addPropertyChangeListener(childId, info.getPropertyName(), info.getListener(), true);
                        continue;
                    }
                    HwmcaObject.mom.addPropertyChangeListener(childId, info.getPropertyName(), info.getListener(), false);
                }
            }
        }

        public HwmcaObject.ListenerInfo removePropertyChangeListener(HwmcaObject.ListenerInfo info, Collection children) {
            HwmcaObject.ListenerInfo result = super.removePropertyChangeListener(info);
            if (result != null && result instanceof PropagatedListenerInfo && ((PropagatedListenerInfo)result).isPropagated()) {
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    ObjectId childId = (ObjectId)iterator.next();
                    HwmcaObject.mom.removePropertyChangeListener(childId, info.getPropertyName(), info.getListener());
                }
            }
            return result;
        }

        public boolean hasPropagatedListeners() {
            boolean result = false;
            Iterator iterator = this.getListeners().iterator();
            while (iterator.hasNext() && !result) {
                HwmcaObject.ListenerInfo info = (HwmcaObject.ListenerInfo)iterator.next();
                result = info instanceof PropagatedListenerInfo && ((PropagatedListenerInfo)info).isPropagated();
            }
            return result;
        }

        public void propagateListeners(ObjectId id) {
            Iterator iterator = this.getListeners().iterator();
            while (iterator.hasNext()) {
                HwmcaObject.ListenerInfo info = (HwmcaObject.ListenerInfo)iterator.next();
                if (!(info instanceof PropagatedListenerInfo) || !((PropagatedListenerInfo)info).isPropagated()) continue;
                if (id.isInstanceOf(class$com$ibm$hwmca$fw$managed$HwmcaParentObject == null ? HwmcaParentObject.class$("com.ibm.hwmca.fw.managed.HwmcaParentObject") : class$com$ibm$hwmca$fw$managed$HwmcaParentObject)) {
                    HwmcaObject.mom.addPropertyChangeListener(id, info.getPropertyName(), info.getListener(), true);
                    continue;
                }
                HwmcaObject.mom.addPropertyChangeListener(id, info.getPropertyName(), info.getListener(), false);
            }
        }

        public void removeListeners(ObjectId id) {
            Iterator iterator = this.getListeners().iterator();
            while (iterator.hasNext()) {
                HwmcaObject.ListenerInfo info = (HwmcaObject.ListenerInfo)iterator.next();
                if (!(info instanceof PropagatedListenerInfo) || !((PropagatedListenerInfo)info).isPropagated()) continue;
                HwmcaObject.mom.removePropertyChangeListener(id, info.getPropertyName(), info.getListener());
            }
        }
    }

    static class PropagatedListenerInfo
    extends HwmcaObject.ListenerInfo {
        int registerObjects;

        public PropagatedListenerInfo(String propertyName, PropertyChangeListener listener, int registerObjects) {
            super(propertyName, listener);
            this.registerObjects = registerObjects;
        }

        public PropagatedListenerInfo(PropertyChangeListener listener, int registerObjects) {
            super(listener);
            this.registerObjects = registerObjects;
        }

        public int getRegisterObjects() {
            return this.registerObjects;
        }

        public boolean isObject() {
            return this.registerObjects != 1;
        }

        public boolean isPropagated() {
            return this.registerObjects == 1 || this.registerObjects == 2;
        }

        public boolean isApplicable(PropertyChangeEvent event) {
            return this.isObject() && super.isApplicable(event);
        }

        public String toString() {
            StringBuffer result = new StringBuffer(this.getClass().getName()).append("[propertyName=").append(this.getPropertyName()).append(",listener=").append(this.getListener()).append(",isObject=").append(this.isObject()).append(",isPropagated=").append(this.isPropagated()).append("]");
            return result.toString();
        }

        public boolean equals(Object test) {
            boolean result = false;
            if (test instanceof PropagatedListenerInfo) {
                result = super.equals(test) && this.registerObjects == ((PropagatedListenerInfo)test).registerObjects;
            }
            return result;
        }
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        PersistentData parentData;
        ArrayList children;
        private static final long serialVersionUID = -4882553972272531461L;

        private Persistent() {
        }
    }
}

